/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.manager;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.EnderStoragePlugin;
import codechicken.enderstorage.api.Frequency;
import codechicken.lib.util.ServerUtils;
import com.google.common.collect.ImmutableMap;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnderStorageManager {
    private static EnderStorageManager serverManager;
    private static EnderStorageManager clientManager;
    private static Map<StorageType<?>, EnderStoragePlugin<?>> plugins;
    private Map<String, AbstractEnderStorage> storageMap;
    private Map<StorageType<?>, List<AbstractEnderStorage>> storageList;
    public final boolean client;
    private File saveDir;
    private File[] saveFiles;
    private int saveTo;
    private List<AbstractEnderStorage> dirtyStorage;
    private CompoundTag saveTag;

    public EnderStorageManager(boolean client) {
        this.client = client;
        this.storageMap = Collections.synchronizedMap(new HashMap());
        this.storageList = Collections.synchronizedMap(new HashMap());
        this.dirtyStorage = Collections.synchronizedList(new LinkedList());
        for (StorageType<?> key : plugins.keySet()) {
            this.storageList.put(key, new ArrayList());
        }
        if (!client) {
            this.load();
        }
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EnderStorageManager::onServerStarted);
    }

    private static void onServerStarted(ServerStartedEvent event) {
        EnderStorageManager.reloadManager(false);
    }

    private void sendClientInfo(ServerPlayer player) {
        for (Map.Entry<StorageType<?>, EnderStoragePlugin<?>> plugin : plugins.entrySet()) {
            plugin.getValue().sendClientInfo(player, (List)EnderStorageManager.unsafeCast(this.storageList.get(plugin.getKey())));
        }
    }

    private static <T> T unsafeCast(Object object) {
        return (T)object;
    }

    private void load() {
        this.saveDir = new File(ServerUtils.getSaveDirectory().toFile(), "EnderStorage");
        try {
            if (!this.saveDir.exists()) {
                this.saveDir.mkdirs();
            }
            this.saveFiles = new File[]{new File(this.saveDir, "data1.dat"), new File(this.saveDir, "data2.dat"), new File(this.saveDir, "lock.dat")};
            if (this.saveFiles[2].exists() && this.saveFiles[2].length() > 0L) {
                FileInputStream fin = new FileInputStream(this.saveFiles[2]);
                this.saveTo = fin.read() ^ 1;
                fin.close();
                if (this.saveFiles[this.saveTo ^ 1].exists()) {
                    FileInputStream in = new FileInputStream(this.saveFiles[this.saveTo ^ 1]);
                    this.saveTag = NbtIo.m_128939_((InputStream)in);
                    in.close();
                } else {
                    this.saveTag = new CompoundTag();
                }
            } else {
                this.saveTag = new CompoundTag();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("EnderStorage was unable to read it's data, please delete the 'EnderStorage' folder Here: %s and start the server again.", this.saveDir), e);
        }
    }

    private void save(boolean force) {
        if (!this.dirtyStorage.isEmpty() || force) {
            for (AbstractEnderStorage inv : this.dirtyStorage) {
                this.saveTag.m_128365_(inv.freq + ",type=" + inv.type(), (Tag)inv.saveToTag());
                inv.setClean();
            }
            this.dirtyStorage.clear();
            try {
                File saveFile = this.saveFiles[this.saveTo];
                if (!saveFile.exists()) {
                    saveFile.createNewFile();
                }
                DataOutputStream dout = new DataOutputStream(new FileOutputStream(saveFile));
                NbtIo.m_128947_((CompoundTag)this.saveTag, (OutputStream)dout);
                dout.close();
                FileOutputStream fout = new FileOutputStream(this.saveFiles[2]);
                fout.write(this.saveTo);
                fout.close();
                this.saveTo ^= 1;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void reloadManager(boolean client) {
        EnderStorageManager newManager = new EnderStorageManager(client);
        if (client) {
            clientManager = newManager;
        } else {
            serverManager = newManager;
        }
    }

    public File getSaveDir() {
        return this.saveDir;
    }

    public static EnderStorageManager instance(boolean client) {
        EnderStorageManager manager;
        EnderStorageManager enderStorageManager = manager = client ? clientManager : serverManager;
        if (manager == null) {
            EnderStorageManager.reloadManager(client);
            manager = client ? clientManager : serverManager;
        }
        return manager;
    }

    public <T extends AbstractEnderStorage> T getStorage(Frequency freq, StorageType<T> type) {
        String key = freq + ",type=" + type.name;
        AbstractEnderStorage storage = this.storageMap.get(key);
        if (storage == null) {
            storage = plugins.get(type).createEnderStorage(this, freq);
            if (!this.client && this.saveTag.m_128441_(key)) {
                storage.loadFromTag(this.saveTag.m_128469_(key));
            }
            this.storageMap.put(key, storage);
            this.storageList.get(type).add(storage);
        }
        return (T)storage;
    }

    public static void registerPlugin(EnderStoragePlugin<?> plugin) {
        plugins.put(plugin.identifier(), plugin);
        if (serverManager != null) {
            EnderStorageManager.serverManager.storageList.put(plugin.identifier(), new ArrayList());
        }
        if (clientManager != null) {
            EnderStorageManager.clientManager.storageList.put(plugin.identifier(), new ArrayList());
        }
    }

    public static EnderStoragePlugin<?> getPlugin(StorageType<?> identifier) {
        return plugins.get(identifier);
    }

    public static Map<StorageType<?>, EnderStoragePlugin<?>> getPlugins() {
        return ImmutableMap.copyOf(plugins);
    }

    public List<String> getValidKeys(String identifer) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.saveTag.m_128431_()) {
            if (!key.endsWith(",type=" + identifer)) continue;
            list.add(key.replace(",type=" + identifer, ""));
        }
        return list;
    }

    public void requestSave(AbstractEnderStorage storage) {
        this.dirtyStorage.add(storage);
    }

    static {
        plugins = new HashMap();
    }

    public static class StorageType<T extends AbstractEnderStorage> {
        public final String name;

        public StorageType(String name) {
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (!(obj instanceof StorageType)) {
                return false;
            }
            StorageType other = (StorageType)obj;
            return other.name.equals(this.name);
        }
    }

    public static class EnderStorageSaveHandler {
        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            if (event.getWorld().m_5776_()) {
                EnderStorageManager.reloadManager(true);
            }
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            if (!event.getWorld().m_5776_() && EnderStorageManager.instance(false) != null) {
                EnderStorageManager.instance(false).save(false);
            }
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            EnderStorageManager.instance(false).sendClientInfo((ServerPlayer)event.getPlayer());
        }

        @SubscribeEvent
        public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            EnderStorageManager.instance(false).sendClientInfo((ServerPlayer)event.getPlayer());
        }
    }
}

